org 100h ; assume ah=bx=0 sp=-2 bp=0x9?? si=0x100

  mov al,0x93
  int 0x10
  push 0x9ff6
  pop es

M mov ax,0xcccd
  mul di        ; dx = y, dl:ah = x, carry = 1 (almost always)
  sbb word[si],-1   ; decrement [si]=t a few times per frame
  xchg ax,bx
  mov al,0x10 ; al = gray ramp, ch = error of last pixel
  add dh,0x9c ; adjust y (can be 0x80 .. 0xb7)

  pusha ; [-18   -16   -14   -12   -10 -9 -8 -7 -6 -5 -4 -3]
        ;   di    si    bp    sp    bl bh dl dh cl ch al ah
        ;   addr  0x100 0x9?? -2          ( y )    color
        ;                              ( x )
  mov bx,-8
  fild word[bx]
  fiadd word[bx-1]
K equ $-2 ; K=-185
  fabs            ; z=|x+y|
  fist dword[bp+si]

  fidivr word[byte si-0x100+K] ; w=K/z

  fldln2
  fadd st1
  fimul word[si]
  fistp word[bx+si]  ; v=(0.693-w)*t: accelerate
  mov ah,[bx+si]

  fimul word[bx]
  fistp word[bx+si]  ; u=x*w
  xor ah,[bx+si]     ; c=xor(u,v)

  mul word[bp+si]
  shr dx,3
  add [bx+3],dx   ; color = 0x10 + c*z/4 + error

  popa

  stosb
  jmp M ; time
